#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""
This experiment was created using PsychoPy2 Experiment Builder (v1.70.00), November 12, 2014, at 13:51
If you publish work using this script please cite the relevant PsychoPy publications
  Peirce, JW (2007) PsychoPy - Psychophysics software in Python. Journal of Neuroscience Methods, 162(1-2), 8-13.
  Peirce, JW (2009) Generating stimuli for neuroscience using PsychoPy. Frontiers in Neuroinformatics, 2:10. doi: 10.3389/neuro.11.010.2008
"""
import numpy as np  # whole numpy lib is available, pre-pend 'np.'
from numpy import sin, cos, tan, log, log10, pi, average, sqrt, std, deg2rad, rad2deg, linspace, asarray
from numpy.random import random, randint, normal, shuffle
import os #handy system and path functions
from psychopy import core, data, event, visual, gui
import psychopy.log #import like this so it doesn't interfere with numpy.log
from psychopy.constants import *

#store info about the experiment session
expName='None'#from the Builder filename that created this script
expInfo={'participant':'', 'session':'001'}
dlg=gui.DlgFromDict(dictionary=expInfo,title=expName)
if dlg.OK==False: core.quit() #user pressed cancel
expInfo['date']=data.getDateStr()#add a simple timestamp
expInfo['expName']=expName
#setup files for saving
if not os.path.isdir('data'):
    os.makedirs('data') #if this fails (e.g. permissions) we will get error
filename='data' + os.path.sep + '%s_%s' %(expInfo['participant'], expInfo['date'])
psychopy.log.console.setLevel(psychopy.log.WARNING)#this outputs to the screen, not a file
logFile=psychopy.log.LogFile(filename+'.log', level=psychopy.log.EXP)

#setup the Window
win = visual.Window(size=(1680, 1050), fullscr=True, screen=0, allowGUI=False, allowStencil=False,
    monitor='testMonitor', color=[0,0,0], colorSpace='rgb')

#Initialise components for routine:istruzioni
istruzioniClock=core.Clock()
istr=visual.TextStim(win=win, ori=0, name='istr',
    text='scegli la freccia a destra se compare una parola e la freccia sinistra se compare una non parola ',
    font='Arial',
    pos=[0, 0], height=0.1,
    color='white', colorSpace='rgb')

#set up handler to look after randomisation of conditions etc
trials_2=data.TrialHandler(nReps=2, method='random', 
    extraInfo=expInfo, originPath=u'/Users/margheritabracci/Desktop/esperimento parole/parole.psyexp',
    trialList=data.importConditions('parolefile.xlsx'))
thisTrial_2=trials_2.trialList[0]#so we can initialise stimuli with some values
#abbreviate parameter names if possible (e.g. rgb=thisTrial_2.rgb)
if thisTrial_2!=None:
    for paramName in thisTrial_2.keys():
        exec(paramName+'=thisTrial_2.'+paramName)

#Initialise components for routine:trial
trialClock=core.Clock()
text=visual.TextStim(win=win, ori=0, name='text',
    text='nonsense',
    font=u'Arial',
    pos=[0, 0], height=0.4,
    color=1.0, colorSpace=u'rgb')

#Initialise components for routine:ringraziamenti_
ringraziamenti_Clock=core.Clock()
ringr=visual.TextStim(win=win, ori=0, name='ringr',
    text=u"L'esperimento \xe8 finito \nGRAZIE!",
    font=u'Arial',
    pos=[0, 0], height=0.1,
    color=u'white', colorSpace=u'rgb')

#Start of routine istruzioni
t=0; istruzioniClock.reset()
frameN=-1

#update component parameters for each repeat
key_resp = event.BuilderKeyResponse() #create an object of type KeyResponse
key_resp.status=NOT_STARTED
#keep track of which have finished
istruzioniComponents=[]#to keep track of which have finished
istruzioniComponents.append(istr)
istruzioniComponents.append(key_resp)
for thisComponent in istruzioniComponents:
    if hasattr(thisComponent,'status'): thisComponent.status = NOT_STARTED
#start the Routine
continueRoutine=True
while continueRoutine:
    #get current time
    t=istruzioniClock.getTime()
    frameN=frameN+1#number of completed frames (so 0 in first frame)
    #update/draw components on each frame
    
    #*istr* updates
    if t>=0.0 and istr.status==NOT_STARTED:
        #keep track of start time/frame for later
        istr.tStart=t#underestimates by a little under one frame
        istr.frameNStart=frameN#exact frame index
        istr.setAutoDraw(True)
    
    #*key_resp* updates
    if t>=0.0 and key_resp.status==NOT_STARTED:
        #keep track of start time/frame for later
        key_resp.tStart=t#underestimates by a little under one frame
        key_resp.frameNStart=frameN#exact frame index
        key_resp.status=STARTED
        #keyboard checking is just starting
        key_resp.clock.reset() # now t=0
        event.clearEvents()
    if key_resp.status==STARTED:#only update if being drawn
        theseKeys = event.getKeys()
        if len(theseKeys)>0:#at least one key was pressed
            key_resp.keys=theseKeys[-1]#just the last key pressed
            key_resp.rt = key_resp.clock.getTime()
            #abort routine on response
            continueRoutine=False
    
    #check if all components have finished
    if not continueRoutine:
        break # lets a component forceEndRoutine
    continueRoutine=False#will revert to True if at least one component still running
    for thisComponent in istruzioniComponents:
        if hasattr(thisComponent,"status") and thisComponent.status!=FINISHED:
            continueRoutine=True; break#at least one component has not yet finished
    
    #check for quit (the [Esc] key)
    if event.getKeys(["escape"]): core.quit()
    #refresh the screen
    if continueRoutine:#don't flip if this routine is over or we'll get a blank screen
        win.flip()

#end of routine istruzioni
for thisComponent in istruzioniComponents:
    if hasattr(thisComponent,"setAutoDraw"): thisComponent.setAutoDraw(False)

for thisTrial_2 in trials_2:
    currentLoop = trials_2
    #abbrieviate parameter names if possible (e.g. rgb=thisTrial_2.rgb)
    if thisTrial_2!=None:
        for paramName in thisTrial_2.keys():
            exec(paramName+'=thisTrial_2.'+paramName)
    
    #Start of routine trial
    t=0; trialClock.reset()
    frameN=-1
    
    #update component parameters for each repeat
    text.setColor(u'white', colorSpace=u'rgb')
    text.setText(stimolo)
    key_resp_2 = event.BuilderKeyResponse() #create an object of type KeyResponse
    key_resp_2.status=NOT_STARTED
    #keep track of which have finished
    trialComponents=[]#to keep track of which have finished
    trialComponents.append(text)
    trialComponents.append(key_resp_2)
    for thisComponent in trialComponents:
        if hasattr(thisComponent,'status'): thisComponent.status = NOT_STARTED
    #start the Routine
    continueRoutine=True
    while continueRoutine:
        #get current time
        t=trialClock.getTime()
        frameN=frameN+1#number of completed frames (so 0 in first frame)
        #update/draw components on each frame
        
        #*text* updates
        if t>=0.0 and text.status==NOT_STARTED:
            #keep track of start time/frame for later
            text.tStart=t#underestimates by a little under one frame
            text.frameNStart=frameN#exact frame index
            text.setAutoDraw(True)
        elif text.status==STARTED and t>=(0.0+1.0):
            text.setAutoDraw(False)
        
        #*key_resp_2* updates
        if t>=0.6 and key_resp_2.status==NOT_STARTED:
            #keep track of start time/frame for later
            key_resp_2.tStart=t#underestimates by a little under one frame
            key_resp_2.frameNStart=frameN#exact frame index
            key_resp_2.status=STARTED
            #keyboard checking is just starting
            key_resp_2.clock.reset() # now t=0
            event.clearEvents()
        if key_resp_2.status==STARTED:#only update if being drawn
            theseKeys = event.getKeys(keyList=['left', 'right'])
            if len(theseKeys)>0:#at least one key was pressed
                key_resp_2.keys=theseKeys[-1]#just the last key pressed
                key_resp_2.rt = key_resp_2.clock.getTime()
                #was this 'correct'?
                if (key_resp_2.keys==str(corrAns)): key_resp_2.corr=1
                else: key_resp_2.corr=0
                #abort routine on response
                continueRoutine=False
        
        #check if all components have finished
        if not continueRoutine:
            break # lets a component forceEndRoutine
        continueRoutine=False#will revert to True if at least one component still running
        for thisComponent in trialComponents:
            if hasattr(thisComponent,"status") and thisComponent.status!=FINISHED:
                continueRoutine=True; break#at least one component has not yet finished
        
        #check for quit (the [Esc] key)
        if event.getKeys(["escape"]): core.quit()
        #refresh the screen
        if continueRoutine:#don't flip if this routine is over or we'll get a blank screen
            win.flip()
    
    #end of routine trial
    for thisComponent in trialComponents:
        if hasattr(thisComponent,"setAutoDraw"): thisComponent.setAutoDraw(False)
    #check responses
    if len(key_resp_2.keys)==0: #No response was made
       key_resp_2.keys=None
       #was no response the correct answer?!
       if str(corrAns).lower()=='none':key_resp_2.corr=1 #correct non-response
       else: key_resp_2.corr=0 #failed to respond (incorrectly)
    #store data for trials_2 (TrialHandler)
    trials_2.addData('key_resp_2.keys',key_resp_2.keys)
    trials_2.addData('key_resp_2.corr',key_resp_2.corr)
    if key_resp_2.keys != None:#we had a response
        trials_2.addData('key_resp_2.rt',key_resp_2.rt)

#completed 2 repeats of 'trials_2'

trials_2.saveAsPickle(filename+'trials_2')
trials_2.saveAsExcel(filename+'.xlsx', sheetName='trials_2',
    stimOut=['corrAns', 'lunghezza', 'parnonpar', 'stimolo', 'violazioni', ],
    dataOut=['n','all_mean','all_std', 'all_raw'])

#Start of routine ringraziamenti_
t=0; ringraziamenti_Clock.reset()
frameN=-1

#update component parameters for each repeat
#keep track of which have finished
ringraziamenti_Components=[]#to keep track of which have finished
ringraziamenti_Components.append(ringr)
for thisComponent in ringraziamenti_Components:
    if hasattr(thisComponent,'status'): thisComponent.status = NOT_STARTED
#start the Routine
continueRoutine=True
while continueRoutine:
    #get current time
    t=ringraziamenti_Clock.getTime()
    frameN=frameN+1#number of completed frames (so 0 in first frame)
    #update/draw components on each frame
    
    #*ringr* updates
    if t>=0.0 and ringr.status==NOT_STARTED:
        #keep track of start time/frame for later
        ringr.tStart=t#underestimates by a little under one frame
        ringr.frameNStart=frameN#exact frame index
        ringr.setAutoDraw(True)
    elif ringr.status==STARTED and t>=(0.0+1.0):
        ringr.setAutoDraw(False)
    
    #check if all components have finished
    if not continueRoutine:
        break # lets a component forceEndRoutine
    continueRoutine=False#will revert to True if at least one component still running
    for thisComponent in ringraziamenti_Components:
        if hasattr(thisComponent,"status") and thisComponent.status!=FINISHED:
            continueRoutine=True; break#at least one component has not yet finished
    
    #check for quit (the [Esc] key)
    if event.getKeys(["escape"]): core.quit()
    #refresh the screen
    if continueRoutine:#don't flip if this routine is over or we'll get a blank screen
        win.flip()

#end of routine ringraziamenti_
for thisComponent in ringraziamenti_Components:
    if hasattr(thisComponent,"setAutoDraw"): thisComponent.setAutoDraw(False)

#Shutting down:
win.close()
core.quit()
